#!/bin/bash
 
#####################################################################################
#                                                                                   #
# * APMinstaller v.2.9                                                              #
# * CentOS7                                                                         #
# * Apache 2.4.35 , MariaDB 10.3.X, PHP 7.2.X setup shell script                    #
# * Created Date    : 2018/11/26                                                    #
# * Created by  : Joo Sung ( webmaster@apachezone.com )                             #
#                                                                                   #
#####################################################################################

##########################################
#                                        #
#           repositories install         #
#                                        #
########################################## 

yum -y update
yum -y install wget openssh-clients bind-utils git nc vim-enhanced man ntsysv \
iotop sysstat strace lsof mc lrzsz zip unzip bzip2 net-tools

curl -sS https://getcomposer.org/installer | /usr/bin/php && mv composer.phar /usr/local/bin/composer


yum -y install https://centos7.iuscommunity.org/ius-release.rpm
sed -i '6s/enabled=0/enabled=1/' /etc/yum.repos.d/ius.repo
sed -i '6s/enabled=0/enabled=1/' /etc/yum.repos.d/epel.repo

rpm -Uvh http://rpms.famillecollet.com/enterprise/remi-release-7.rpm

echo "[mariadb]" > /etc/yum.repos.d/MariaDB.repo
echo "name = MariaDB" >> /etc/yum.repos.d/MariaDB.repo
echo "baseurl = http://yum.mariadb.org/10.3/rhel7-amd64" >> /etc/yum.repos.d/MariaDB.repo
echo "gpgkey=https://yum.mariadb.org/RPM-GPG-KEY-MariaDB" >> /etc/yum.repos.d/MariaDB.repo
echo "gpgcheck=1" >> /etc/yum.repos.d/MariaDB.repo 

yum -y update

##########################################
#                                        #
#          아파치 및 HTTP2 설치              #
#                                        #
########################################## 

# Nghttp2 설치
yum --enablerepo=epel -y install libnghttp2

# /etc/mime.types 설치 
yum -y install mailcap

# httpd 설치
yum -y install c-ares

yum -y --disablerepo=base,extras,updates --enablerepo=ius install httpd

yum -y install openldap-devel expat-devel

yum -y install libdb-devel perl

yum -y --disablerepo=base,extras,updates --enablerepo=ius -y install httpd-devel mod_ssl

systemctl start httpd
systemctl enable httpd

firewall-cmd --permanent --zone=public --add-service=http
firewall-cmd --permanent --zone=public --add-service=https
firewall-cmd --reload

cp -av /etc/httpd/conf/httpd.conf /etc/httpd/conf/httpd.conf.original
sed -i 's/DirectoryIndex index.html/DirectoryIndex index.html index.htm index.php index.php3 index.cgi index.jsp/' /etc/httpd/conf/httpd.conf
sed -i 's/Options Indexes FollowSymLinks/Options FollowSymLinks/' /etc/httpd/conf/httpd.conf
sed -i 's/#ServerName www.example.com:80/ServerName localhost:80/' /etc/httpd/conf/httpd.conf
sed -i 's/UserDir disabled/#UserDir disabled/' /etc/httpd/conf.d/userdir.conf
sed -i 's/#UserDir public_html/UserDir public_html/' /etc/httpd/conf.d/userdir.conf
sed -i 's/Options MultiViews Indexes SymLinksIfOwnerMatch IncludesNoExec/Options MultiViews SymLinksIfOwnerMatch IncludesNoExec/' /etc/httpd/conf.d/userdir.conf
sed -i 's/LoadModule mpm_prefork_module modules/#LoadModule mpm_prefork_module modules/' /etc/httpd/conf.modules.d/00-mpm.conf
sed -i 's/#LoadModule mpm_event_module modules/LoadModule mpm_event_module modules/' /etc/httpd/conf.modules.d/00-mpm.conf

cp index.html /var/www/html/

systemctl restart httpd

##########################################
#                                        #
#         PHP7.2 및 라이브러리 설치           #
#                                        #
########################################## 

# PHP 7.2 설치. ( 7.1 또는 7.0 설치 하실분은 php72 를 php71 또는 php70 으로 변경 하시고 저장 하시면 됩니다.)

yum -y --enablerepo=remi,remi-php72 install php
yum -y --enablerepo=remi,remi-php72 install php-cli php-fpm \
php-common php-devel php-gd php-imap php-json php-ldap \
php-mbstring php-mcrypt php-mysqlnd php-opcache php-soap php-xml \
php-xmlrpc php-pdo uwsgi-plugin-php php-ioncube-loader php-pecl-apcu \
php-pecl-geoip php-pecl-imagick php-pecl-memcached php-pecl-redis php-pecl-xdebug \
php-pgsql php-process php-snmp




cp -av /etc/php.ini /etc/php.ini.original
sed -i 's/short_open_tag = Off/short_open_tag = On/' /etc/php.ini
sed -i 's/expose_php = On/expose_php = Off/' /etc/php.ini
sed -i 's/display_errors = Off/display_errors = On/' /etc/php.ini
sed -i 's/;error_log = php_errors.log/error_log = php_errors.log/' /etc/php.ini
sed -i 's/error_reporting = E_ALL \& ~E_DEPRECATED/error_reporting = E_ALL \& ~E_NOTICE \& ~E_DEPRECATED \& ~E_USER_DEPRECATED/' /etc/php.ini
sed -i 's/variables_order = "GPCS"/variables_order = "EGPCS"/' /etc/php.ini
sed -i 's/post_max_size = 8M/post_max_size = 100M/' /etc/php.ini
sed -i 's/upload_max_filesize = 2M/upload_max_filesize = 100M/' /etc/php.ini
sed -i 's/;date.timezone =/date.timezone = "Asia\/Seoul"/' /etc/php.ini
sed -i 's/session.gc_maxlifetime = 1440/session.gc_maxlifetime = 86400/' /etc/php.ini
sed -i 's/allow_url_fopen = On/allow_url_fopen = Off/' /etc/php.ini
sed -i 's/disable_functions =/disable_functions = system,exec,passthru,proc_open,popen,curl_multi_exec,parse_ini_file,show_source/' /etc/php.ini 

systemctl restart httpd

echo '<?php
phpinfo();
?>' >> /var/www/html/phpinfo.php



##########################################
#                                        #
#          MARIADB 10.3.X 설치            #
#                                        #
########################################## 

# MariaDB 10.3.x 설치
yum -y install MariaDB-server MariaDB-client

# MariaDB my.cnf 복사
#cp -av /usr/share/mysql/my-huge.cnf /etc/my.cnf.d/

systemctl enable mariadb
systemctl start mariadb

# S.M.A.R.T. 디스크 모니터링을 설치
yum -y install smartmontools

systemctl enable smartd
systemctl start smartd

##########################################
#                                        #
#           SELINUX disabled             #
#                                        #
##########################################

sed -i 's/SELINUX=enforcing/SELINUX=disabled/' /etc/selinux/config

/usr/sbin/setenforce 0
exit 0

##########################################
#                                        #
#          iptables 방화벽 설정            #
#                                        #
##########################################  


# iptables 방화벽을 사용 하려면 아래 # 주석을 제거하고 80,443 포트를 개방 설정 해준 다음 아래와 같이 리스타트 시킨다.
#systemctl mask firewalld  
#systemctl stop firewalld 
#yum -y install iptables-services
#systemctl enable iptables 
#systemctl start iptables
#sed -i 's/-A INPUT -i lo -j ACCEPT/-A INPUT -i lo -j ACCEPT\n-A INPUT -p tcp -m state --state NEW -m tcp --dport 443 -j ACCEPT/' /etc/sysconfig/iptables
#sed -i 's/-A INPUT -i lo -j ACCEPT/-A INPUT -i lo -j ACCEPT\n-A INPUT -p tcp -m state --state NEW -m tcp --dport 80 -j ACCEPT/' /etc/sysconfig/iptables
#service iptables restart
